/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.visio.model.reader;

import java.io.IOException;
import java.io.Reader;

class VisioBufferedReader
extends Reader {
    private Reader m_reader = null;
    private int m_nBufferIndex = 0;
    private int m_nBufferLength = 0;
    private char[] m_buffer = new char[32768];

    public VisioBufferedReader(Reader reader) {
        this.m_reader = reader;
    }

    public int read() throws IOException {
        if (this.m_nBufferIndex == this.m_nBufferLength) {
            this.fetchMoreData();
        }
        if (this.m_nBufferLength == -1) {
            return -1;
        }
        return this.m_buffer[this.m_nBufferIndex++];
    }

    public int peek() throws IOException {
        if (this.m_nBufferIndex == this.m_nBufferLength) {
            this.fetchMoreData();
        }
        if (this.m_nBufferLength == -1) {
            return -1;
        }
        return this.m_buffer[this.m_nBufferIndex];
    }

    private void fetchMoreData() throws IOException {
        this.m_nBufferLength = this.m_reader.read(this.m_buffer, 0, this.m_buffer.length);
        this.m_nBufferIndex = 0;
    }

    public void pushback() {
        if (this.m_nBufferIndex == 0) {
            return;
        }
        --this.m_nBufferIndex;
    }

    public void close() throws IOException {
        this.m_reader.close();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        return 0;
    }
}

